/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsIntColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.driver.SqlServerDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqlServerSupporter
extends RdbmsSupporter {
    public static final String VALIDATION_SQL = "select 1";

    public SqlServerSupporter() {
        super(new SqlServerDriver());
    }

    public boolean isSqlServer() {
        return true;
    }

    public List fetchCriteria(Connection conn, RdbmsPagingQuery query) throws SQLException {
        ArrayList<RdbmsColumnValue[]> items = new ArrayList<RdbmsColumnValue[]>();
        String sql = this.generateCriteriaQuery(query);
        sql = this.properties.encode(sql);
        PreparedStatement pstmt = conn.prepareStatement(sql);
        int index = 0;
        RdbmsColumnParameter[] rdbms_column_parameters = query.getWhereSet();
        if (rdbms_column_parameters != null) {
            int j = 0;
            while (j < rdbms_column_parameters.length) {
                rdbms_column_parameters[j].setIndex(++index);
                ++j;
            }
            this.setPreparedStatement(pstmt, rdbms_column_parameters);
        }
        ResultSet rs = pstmt.executeQuery();
        rs.setFetchSize(query.getScale());
        try {
            RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
            int skip = this.getRowSkip();
            while (rs.next()) {
                if (skip != 0) {
                    --skip;
                    continue;
                }
                RdbmsColumnValue[] columnValues = new RdbmsColumnValue[query.getColumns().length];
                int i = 0;
                while (i < columnValues.length) {
                    String column = query.getColumns()[i].toUpperCase();
                    int resultset_column_index = i + 1;
                    String rs_column_name = rs.getMetaData().getColumnName(resultset_column_index).toUpperCase();
                    if (!column.equalsIgnoreCase(rs_column_name)) {
                        int as_index = column.indexOf("AS");
                        int rs_column_index = column.indexOf(rs_column_name);
                        if (as_index < 0 || rs_column_index < 0 || as_index > rs_column_index) {
                            rs_column_name = rs.getMetaData().getColumnName(++resultset_column_index).toUpperCase();
                        }
                    }
                    int columnType = rs.getMetaData().getColumnType(resultset_column_index);
                    columnValues[i] = rdbmsSupporter.getDbColumnValue(rs_column_name, resultset_column_index, columnType);
                    columnValues[i].set(rs);
                    ++i;
                }
                items.add(columnValues);
                if (query.getScale() != items.size()) continue;
                break;
            }
        }
        finally {
            ConnectionFactory.release(rs, pstmt);
        }
        return items;
    }

    public String generateCriteriaQuery(RdbmsPagingQuery info) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM (").append("SELECT TOP ").append(info.getScale()).append(" ").append(this.extractSumAliasing(info.getSelectSet())).append(" FROM ( ").append("SELECT TOP ").append(info.getStart() - 1 + info.getScale()).append(" ").append(info.getSelectSet()).append(" ").append(info.getFromSet()).append(" ").append(info.getWhereString()).append(" ").append(info.getGroupString()).append(" ").append(info.getOrderString()).append(") _LIST00 ").append(" ").append(this.reverseOrderString(info.getOrderString())).append(") _LIST01 ").append(" " + info.getOrderString());
        return query.toString();
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return new RdbmsIntColumnValue(name, index);
            }
            case -5: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return new RdbmsStringColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case -1: 
            case 2005: {
                return new RdbmsStringColumnValue(name, index);
            }
        }
        return new RdbmsBinaryStreamColumnValue(name, index);
    }

    private String extractSumAliasing(String selectSet) {
        String[] sArr = selectSet.toUpperCase().split(",");
        String[] rArr = new String[sArr.length];
        int asIndex = 0;
        int i = 0;
        while (i < sArr.length) {
            if (sArr[i].indexOf("SUM") >= 0 && sArr[i].indexOf("AS") > 0) {
                asIndex = sArr[i].indexOf("AS");
                rArr[i] = new String(sArr[i].toCharArray(), asIndex + 3, sArr[i].length() - (asIndex + 3));
            } else {
                rArr[i] = sArr[i];
            }
            ++i;
        }
        return StringUtil.format(rArr, ',');
    }

    private String reverseOrderString(String target) {
        String result = new String();
        if ((target = target.toUpperCase()).indexOf("ASC") > 0 && target.indexOf("DESC") > 0) {
            String[] sArr = target.split(",");
            String[] rArr = new String[sArr.length];
            int i = 0;
            while (i < sArr.length) {
                if (sArr[i].indexOf("ASC") > 0) {
                    rArr[i] = StringUtil.patternReplace(sArr[i], "ASC", "DESC");
                } else if (sArr[i].indexOf("DESC") > 0) {
                    rArr[i] = StringUtil.patternReplace(sArr[i], "DESC", "ASC");
                }
                ++i;
            }
            result = StringUtil.format(rArr, ',');
        } else if (target.indexOf("ASC") > 0) {
            result = StringUtil.patternReplace(target, "ASC", "DESC");
        } else if (target.indexOf("DESC") > 0) {
            result = StringUtil.patternReplace(target, "DESC", "ASC");
        } else {
            return target;
        }
        return result;
    }

    public int getRowSkip() {
        return 0;
    }

    public static void main(String[] args) {
        String target1 = "aaa asc";
        String target2 = "bbb desc";
        String target3 = "ccc asc, ddd desc";
        String target4 = "eee desc, fff asc";
        String target5 = "sum(ggg) as hhh desc, iii asc";
        SqlServerSupporter sup = new SqlServerSupporter();
        System.out.println("1 : " + sup.reverseOrderString(target1));
        System.out.println("2 : " + sup.reverseOrderString(target2));
        System.out.println("3 : " + sup.reverseOrderString(target3));
        System.out.println("4 : " + sup.reverseOrderString(target4));
        System.out.println("5 : " + sup.reverseOrderString(target5));
    }

    public String old_generateCriteriaQuery(RdbmsPagingQuery info) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM (\n");
        query.append("  SELECT TOP ");
        query.append(String.valueOf(info.getStart() - 1 + info.getScale()) + " ");
        query.append(info.getSelectSet());
        query.append(" " + info.getFromSet());
        query.append(" " + info.getWhereString());
        query.append(" " + info.getGroupString());
        query.append(" " + info.getOrderString());
        query.append(")_LIST00 where _LIST00." + info.getPrimaryColumn() + " NOT IN (\n");
        query.append("SELECT TOP ");
        query.append(String.valueOf(info.getStart() - 1) + " " + info.getPrimaryColumn() + "\n");
        query.append(" " + info.getFromSet());
        query.append(" " + info.getWhereString());
        query.append(" " + info.getGroupString());
        query.append(" " + info.getOrderString());
        query.append(")");
        return query.toString();
    }

    public String getValidateSql() {
        return VALIDATION_SQL;
    }
}

