/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.ir.util.rdbms.column.fetch.RdbmsBlobColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBytesColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.driver.TiberoDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporterFamily;
import java.sql.Connection;
import java.sql.SQLException;

public class TiberoSupporter
extends RdbmsSupporter
implements RdbmsSupporterFamily {
    public static final String VALIDATION_SQL = "select 1 from dual";

    public TiberoSupporter() {
        super(new TiberoDriver());
    }

    public String generateCriteriaQuery(RdbmsPagingQuery info) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM\n");
        sql.append("(");
        sql.append("SELECT ROWNUM AS RNUM, A.* FROM (\n");
        sql.append("  SELECT ");
        sql.append(String.valueOf(info.getSelectSet()) + "\n");
        sql.append("  " + info.getFromSet());
        sql.append("  " + info.getWhereString());
        sql.append("  " + info.getGroupString());
        sql.append("  " + info.getOrderString());
        sql.append(") A \n  ");
        sql.append("WHERE ROWNUM <= " + (info.getStart() + info.getScale()) + "\n");
        sql.append(") WHERE RNUM > " + (info.getStart() - 1));
        return sql.toString();
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 2005: {
                return new RdbmsStringColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case 2004: {
                return new RdbmsBlobColumnValue(name, index);
            }
            case -4: 
            case -3: 
            case -2: {
                return new RdbmsBytesColumnValue(name, index);
            }
        }
        return new RdbmsStringColumnValue(name, index);
    }

    public int getRowSkip() {
        return 0;
    }

    public RdbmsSupporter getMatched(Connection conn) throws SQLException {
        if (this.match(conn)) {
            return this;
        }
        return null;
    }

    public String getValidateSql() {
        return VALIDATION_SQL;
    }
}

