/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.util.Map;
import org.apache.ibatis.ognl.ASTKeyValue;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;

class ASTMap
extends SimpleNode {
    private static Class DEFAULT_MAP_CLASS;
    private String className;
    static /* synthetic */ Class class$0;

    static {
        try {
            DEFAULT_MAP_CLASS = Class.forName("java.util.LinkedHashMap");
        }
        catch (ClassNotFoundException ex) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.HashMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DEFAULT_MAP_CLASS = clazz;
        }
    }

    public ASTMap(int id) {
        super(id);
    }

    public ASTMap(OgnlParser p, int id) {
        super(p, id);
    }

    protected void setClassName(String value) {
        this.className = value;
    }

    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Map answer;
        if (this.className == null) {
            try {
                answer = (Map)DEFAULT_MAP_CLASS.newInstance();
            }
            catch (Exception ex) {
                throw new OgnlException("Default Map class '" + DEFAULT_MAP_CLASS.getName() + "' instantiation error", ex);
            }
        }
        try {
            answer = (Map)OgnlRuntime.classForName(context, this.className).newInstance();
        }
        catch (Exception ex) {
            throw new OgnlException("Map implementor '" + this.className + "' not found", ex);
        }
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            ASTKeyValue kv = (ASTKeyValue)this.children[i];
            Node k = kv.getKey();
            Node v = kv.getValue();
            answer.put(k.getValue(context, source), v == null ? null : v.getValue(context, source));
            ++i;
        }
        return answer;
    }

    public String toString() {
        String result = "#";
        if (this.className != null) {
            result = String.valueOf(result) + "@" + this.className + "@";
        }
        result = String.valueOf(result) + "{ ";
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            ASTKeyValue kv = (ASTKeyValue)this.children[i];
            if (i > 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + kv.getKey() + " : " + kv.getValue();
            ++i;
        }
        return String.valueOf(result) + " }";
    }
}

