/*
 * Decompiled with CFR 0.152.
 */
package x3.client.smeapi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import x3.client.smeapi.SMEConnection;
import x3.client.smeapi.SMEConnectionFactory;
import x3.client.smeapi.SMEException;
import x3.client.smeapi.impl.SMEConnectionImpl;
import x3.client.smeapi.impl.SMELogger;

public class SMEConnectionFactoryImpl
implements SMEConnectionFactory,
Serializable {
    private Vector serverList;
    private int serverCount;
    private Logger logger = SMELogger.getInstance();

    public SMEConnectionFactoryImpl(String connString) throws SMEException {
        this.serverList = new Vector();
        StringTokenizer st = new StringTokenizer(connString, ",; \t\n\r");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            try {
                URL url = null;
                if (!tok.startsWith("sme://")) {
                    throw new SMEException("Unsupported protocol : " + tok);
                }
                url = new URL(tok.replaceAll("sme", "http"));
                this.serverList.add(url);
            }
            catch (MalformedURLException e) {
                this.logger.warn((Object)"MalformedURLException :", (Throwable)e);
                throw new SMEException(e);
            }
        }
        this.serverCount = this.serverList.size();
    }

    public synchronized SMEConnection createConnection(String smeid, String smepass) throws SMEException {
        SMEConnection rt = null;
        try {
            rt = this.openConnection(this.getServerURLs());
            ((SMEConnectionImpl)rt).setClientID(smeid);
            ((SMEConnectionImpl)rt).setClientPassword(smepass);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (rt == null) {
            throw new SMEException("Connect fail...");
        }
        return rt;
    }

    public int getServerCount() {
        return this.serverCount;
    }

    public URL getServerURL(int idx) {
        if (idx < 0 || idx >= this.serverCount) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return (URL)this.serverList.get(idx);
    }

    public URL[] getServerURLs() {
        URL[] url = new URL[this.serverCount];
        int i = 0;
        while (i < this.serverCount) {
            url[i] = (URL)this.serverList.get(i);
            ++i;
        }
        return url;
    }

    protected SMEConnection openConnection(URL[] url) throws IOException {
        try {
            return new SMEConnectionImpl(url);
        }
        catch (SMEException e) {
            throw new IOException(e.getMessage());
        }
    }
}

