/*
 * Decompiled with CFR 0.152.
 */
package x3.client.smeapi.impl;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class SMELogger {
    private static Logger logger;
    protected static String logLayout;
    protected static String logLevel;
    protected static String logPath;
    protected static boolean useConsoleLogger;
    protected static boolean useFileLogger;

    static {
        logLayout = "[%d] [%-5p] %l - %m%n";
        logLevel = "info";
        logPath = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "logfile.log";
        useConsoleLogger = false;
        useFileLogger = false;
    }

    public static void initLogger() {
        logger = Logger.getRootLogger();
        if (useConsoleLogger) {
            SMELogger.addConsoleAppender();
        }
        if (useFileLogger) {
            SMELogger.addDailyRollingFileAppender();
        }
    }

    public static Logger getInstance() {
        if (logger == null) {
            SMELogger.initLogger();
        }
        return logger;
    }

    public static void addConsoleAppender() {
        ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout(logLayout), "System.out");
        logger.addAppender((Appender)appender);
    }

    public static void addDailyRollingFileAppender() {
        DailyRollingFileAppender appender = null;
        try {
            appender = new DailyRollingFileAppender((Layout)new PatternLayout(logLayout), logPath, "'.'yyyy-MM-dd");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((DailyRollingFileAppender)appender).setThreshold((Priority)Level.toLevel((String)logLevel));
        logger.addAppender((Appender)appender);
    }

    public static void setLogLayout(String layout) {
        logLayout = layout;
    }

    public static void setLogLevel(String level) {
        logLevel = level;
    }

    public static void setLogPath(String path) {
        logPath = path;
    }

    public static void setUseConsoleLogger(boolean bool) {
        useConsoleLogger = bool;
    }

    public static void setUseFileLogger(boolean bool) {
        useFileLogger = bool;
    }
}

