/*
 * Decompiled with CFR 0.152.
 */
package x3.client.smeapi.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import x3.client.smeapi.SMEException;
import x3.client.smeapi.SMEListener;
import x3.client.smeapi.SMEReceiver;
import x3.client.smeapi.SMEReport;
import x3.client.smeapi.impl.SMEConnectionImpl;
import x3.client.smeapi.impl.SMEConstants;
import x3.client.smeapi.impl.SMELogger;
import x3.client.smeapi.impl.SMEPacket;
import x3.client.smeapi.impl.SMEReportImpl;
import x3.client.smeapi.impl.SMESessionImpl;
import x3.client.smeapi.impl.SMEUtilSet;

public class SMEReceiverImpl
extends Thread
implements SMEReceiver,
SMEConstants,
Runnable {
    private SMEConnectionImpl connImpl;
    private SMESessionImpl sessImpl;
    private SMEListener listener;
    private Socket socket;
    private BufferedReader input;
    private OutputStream output;
    int socketTimeOut = 10000;
    private boolean isAlive = true;
    private long lastReceiveMillis;
    private long pingTerm = 60000L;
    private int cntSendPing = 0;
    private int serverIndex = 0;
    private URL serverURL;
    private URL[] serverList;
    private Logger logger = SMELogger.getInstance();

    public SMEReceiverImpl(SMEConnectionImpl conn, SMESessionImpl sess) {
        this.connImpl = conn;
        this.sessImpl = sess;
        this.serverList = this.connImpl.getServerList();
        this.serverURL = this.getServerURL();
        Hashtable ht = this.openConnection();
        if (!"100".equals((String)ht.get("CODE"))) {
            this.serverURL = this.getServerURL();
            ht = this.openConnection();
        }
        this.lastReceiveMillis = System.currentTimeMillis();
        this.start();
    }

    private URL getServerURL() {
        this.serverIndex = this.serverIndex + 1 < this.serverList.length && this.serverIndex + 1 >= 1 ? ++this.serverIndex : 0;
        return this.serverList[this.serverIndex];
    }

    private Hashtable openConnection() {
        Hashtable ht = new Hashtable();
        try {
            if (this.socket == null || !this.socket.isConnected()) {
                this.socket = new Socket(this.serverURL.getHost(), this.serverURL.getPort());
                this.socket.setSoTimeout(this.socketTimeOut);
                this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.output = this.socket.getOutputStream();
                this.sendPacket(this.getAuthPacket());
                ht = this.recvPacket();
                if (!"100".equals((String)ht.get("CODE"))) {
                    throw new IOException();
                }
                String pwd = SMEUtilSet.getHashedString(String.valueOf((String)ht.get("DATA")) + this.connImpl.getClientPassword());
                this.sendPacket(this.getConnectPacket(this.connImpl.getClientID(), pwd, true));
                ht = this.recvPacket();
            }
        }
        catch (IOException e) {
            this.logger.warn((Object)"Receiver Connection Error :", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.warn((Object)"Receiver Connection Error :", (Throwable)e);
        }
        return ht;
    }

    public boolean isConnected() {
        return this.socket.isConnected() && !this.socket.isClosed();
    }

    public byte[] getAuthPacket() {
        StringBuffer buf_send = new StringBuffer();
        buf_send.append("BEGIN AUTH\r\n");
        buf_send.append("VERSION:SMGP/2.0.5/MD5\r\n");
        buf_send.append("END\r\n");
        this.logger.info((Object)"RECEIVER_AUTH");
        return buf_send.toString().getBytes();
    }

    public byte[] getConnectPacket(String id, String pwd, boolean isReportLine) {
        StringBuffer buf_send = new StringBuffer();
        buf_send.append("BEGIN CONNECT\r\n");
        buf_send.append("ID:" + id + "\r\n");
        buf_send.append("PASSWORD:" + pwd + "\r\n");
        buf_send.append("REPORTLINE:" + (isReportLine ? "Y" : "N") + "\r\n");
        buf_send.append("VERSION:SMGP/2.0.5/MD5\r\n");
        buf_send.append("END\r\n");
        this.logger.info((Object)("RECEIVER_CONNECT{ID=" + id + ";PASSWORD=" + pwd + ";REPORTLINE=" + isReportLine + ";}"));
        return buf_send.toString().getBytes();
    }

    public byte[] getAckPacket(String key, String code) {
        StringBuffer buf_send = new StringBuffer();
        buf_send.append("BEGIN ACK\r\n");
        buf_send.append("KEY:" + key + "\r\n");
        buf_send.append("CODE:" + code + "\r\n");
        buf_send.append("DATA:\r\n");
        buf_send.append("END\r\n");
        this.logger.info((Object)("RECEIVER_ACK{KEY=" + key + ";CODE=" + code + ";}"));
        return buf_send.toString().getBytes();
    }

    public byte[] getPingPongPacket(String key, String tranType) throws Exception {
        StringBuffer buf_send = new StringBuffer();
        if (tranType.equals("PING")) {
            buf_send.append("BEGIN PING\r\n");
        } else if (tranType.equals("PONG")) {
            buf_send.append("BEGIN PONG\r\n");
        } else {
            throw new Exception();
        }
        buf_send.append("KEY:" + key + "\r\n");
        buf_send.append("END\r\n");
        if (tranType.equals("PING")) {
            this.logger.info((Object)("RECEIVER_PING{KEY=" + key + ";}"));
        } else if (tranType.equals("PONG")) {
            this.logger.info((Object)("RECEIVER_PONG{KEY=" + key + ";}"));
        }
        return buf_send.toString().getBytes();
    }

    public void sendPacket(byte[] packet) throws IOException {
        if (this.isAlive) {
            this.output.flush();
            this.output.write(packet, 0, packet.length);
            this.output.flush();
        }
    }

    private String[] splitPacket(String packetLine, String sep) {
        String[] ret = new String[]{"", ""};
        StringTokenizer st = new StringTokenizer(packetLine, sep);
        try {
            ret[0] = st.nextToken();
            ret[1] = st.nextToken();
        }
        catch (NoSuchElementException e) {
            ret[1] = "";
        }
        return ret;
    }

    public void close() {
        this.isAlive = false;
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Receiver Input Buffer Close :", (Throwable)e);
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Receiver Output Stream Close :", (Throwable)e);
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Receiver Socket Close :", (Throwable)e);
            }
        }
    }

    public void run() {
        Hashtable ht = new Hashtable();
        String readLine = "";
        String[] values = new String[2];
        this.logger.info((Object)"Receiver Run!!");
        while (this.isAlive) {
            block12: {
                try {
                    if (System.currentTimeMillis() - this.lastReceiveMillis <= this.pingTerm) break block12;
                    this.logger.info((Object)"PING Send!!");
                    this.sendPacket(this.getPingPongPacket("11111", "PING"));
                    ++this.cntSendPing;
                }
                catch (ConnectException e) {
                    this.logger.warn((Object)"Run ConnectException :", (Throwable)e);
                    try {
                        SMEReceiverImpl.sleep(5000L);
                        this.isAlive = false;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                catch (SocketException e) {
                    this.logger.warn((Object)"Run SocketException :", (Throwable)e);
                    try {
                        SMEReceiverImpl.sleep(1000L);
                        this.isAlive = false;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Run Exception :", (Throwable)e);
                    this.isAlive = false;
                    break;
                }
            }
            if ((ht = this.recvPacket()).size() > 0) {
                this.process(ht);
                ht = new Hashtable();
                continue;
            }
            try {
                SMEReceiverImpl.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.close();
        this.listener.onMessage(new SMEReportImpl(new SMEPacket(), this));
        this.logger.info((Object)"Receiver Run Exited!!");
    }

    private Hashtable recvPacket() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String[] values = new String[2];
        String readLine = "";
        while (this.isAlive) {
            try {
                readLine = this.input.readLine();
            }
            catch (InterruptedIOException e) {
                return ht;
            }
            catch (IOException e) {
                try {
                    SMEReceiverImpl.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.logger.warn((Object)"Receiver ReceivePacket :", (Throwable)e);
                this.isAlive = false;
                break;
            }
            if (readLine == null) break;
            if (readLine.startsWith("BEGIN")) {
                values = this.splitPacket(readLine, " ");
                ht.put(values[0], values[1]);
            } else {
                values = this.splitPacket(readLine, ":");
                ht.put(values[0], values[1]);
            }
            if (readLine.startsWith("END")) break;
        }
        return ht;
    }

    private synchronized void process(Hashtable ht) {
        if (ht.containsKey("BEGIN")) {
            try {
                if (((String)ht.get("BEGIN")).equals("PONG")) {
                    --this.cntSendPing;
                } else if (((String)ht.get("BEGIN")).equals("REPORT")) {
                    this.listener.onMessage(new SMEReportImpl(this.hashtableToSMEPacket(ht), this));
                    this.logger.info((Object)("RECEIVER_REPORT{KEY=" + (String)ht.get("KEY") + ";CODE=" + (String)ht.get("CODE") + ";}"));
                    if (this.output != null) {
                        this.sendPacket(this.getAckPacket((String)ht.get("KEY"), "100"));
                    }
                }
                this.lastReceiveMillis = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.logger.warn((Object)"Process Function Exception :", (Throwable)e);
            }
        }
    }

    public SMEReport receive() throws SMEException {
        return new SMEReportImpl(new SMEPacket(), this);
    }

    public synchronized SMEReport receive(Hashtable packet) throws SMEException {
        return new SMEReportImpl(new SMEPacket(), this);
    }

    public void setListener(SMEListener listener) {
        this.listener = listener;
    }

    public SMEListener getListener() {
        return this.listener;
    }

    private SMEPacket hashtableToSMEPacket(Hashtable ht) {
        SMEPacket packet = new SMEPacket();
        if (ht != null) {
            Enumeration keys = ht.keys();
            while (keys.hasMoreElements()) {
                String n = (String)keys.nextElement();
                String v = (String)ht.get(n);
                packet.setProperty(n, v);
            }
        }
        return packet;
    }

    public void setPingTerm(int sec) {
        this.pingTerm = sec * 1000;
    }
}

