/*
 * Decompiled with CFR 0.152.
 */
package x3.client.smeapi.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import x3.client.smeapi.SMEException;
import x3.client.smeapi.SMERequest;
import x3.client.smeapi.SMEResponse;
import x3.client.smeapi.SMESender;
import x3.client.smeapi.impl.SMEConnectionImpl;
import x3.client.smeapi.impl.SMEConstants;
import x3.client.smeapi.impl.SMELogger;
import x3.client.smeapi.impl.SMEPacket;
import x3.client.smeapi.impl.SMEResponseImpl;
import x3.client.smeapi.impl.SMESessionImpl;
import x3.client.smeapi.impl.SMEUtilSet;

public class SMESenderImpl
implements SMESender,
SMEConstants {
    private SMEPacket pkt;
    private Socket socket = new Socket();
    private BufferedReader input;
    private OutputStream output;
    int socketTimeOut = 10000;
    private SMEConnectionImpl connImpl;
    private SMESessionImpl sessImpl;
    private int serverIndex = 0;
    private URL serverURL;
    private URL[] serverList;
    private boolean useEncrypt = false;
    private Logger logger = SMELogger.getInstance();

    public SMESenderImpl(SMEConnectionImpl conn, SMESessionImpl sess) throws SMEException {
        this.connImpl = conn;
        this.sessImpl = sess;
        this.serverList = this.connImpl.getServerList();
        this.serverURL = this.getServerURL();
        Hashtable ht = this.openConnection();
        if (!"100".equals((String)ht.get("CODE"))) {
            this.serverURL = this.getServerURL();
            ht = this.openConnection();
        }
    }

    private URL getServerURL() {
        this.serverIndex = this.serverIndex + 1 < this.serverList.length && this.serverIndex + 1 >= 1 ? ++this.serverIndex : 0;
        return this.serverList[this.serverIndex];
    }

    private Hashtable openConnection() {
        Hashtable ht = new Hashtable();
        try {
            if (this.socket == null || !this.socket.isConnected()) {
                this.socket = new Socket(this.serverURL.getHost(), this.serverURL.getPort());
                this.socket.setSoTimeout(this.socketTimeOut);
                this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.output = this.socket.getOutputStream();
                this.sendPacket(this.getAuthPacket());
                ht = this.recvPacket();
                if (!"100".equals((String)ht.get("CODE"))) {
                    throw new IOException();
                }
                String pwd = SMEUtilSet.getHashedString(String.valueOf((String)ht.get("DATA")) + this.connImpl.getClientPassword());
                this.sendPacket(this.getConnectPacket(this.connImpl.getClientID(), pwd, false));
                ht = this.recvPacket();
            }
        }
        catch (IOException e) {
            this.logger.warn((Object)"Receiver Connection Error :", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.warn((Object)"Receiver Connection Error :", (Throwable)e);
        }
        return ht;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public byte[] getAuthPacket() {
        StringBuffer buf_send = new StringBuffer();
        buf_send.append("BEGIN AUTH\r\n");
        buf_send.append("VERSION:SMGP/2.0.5/MD5\r\n");
        buf_send.append("END\r\n");
        this.logger.info((Object)"SENDER_AUTH");
        return buf_send.toString().getBytes();
    }

    private byte[] getConnectPacket(String id, String pwd, boolean isReportLine) {
        StringBuffer buf_send = new StringBuffer();
        buf_send.append("BEGIN CONNECT\r\n");
        buf_send.append("ID:" + id + "\r\n");
        buf_send.append("PASSWORD:" + pwd + "\r\n");
        buf_send.append("REPORTLINE:" + (isReportLine ? "Y" : "N") + "\r\n");
        buf_send.append("VERSION:SMGP/2.0.5/MD5\r\n");
        buf_send.append("END\r\n");
        this.logger.info((Object)("CONNECT{ID=" + id + ";PASSWORD=" + pwd + ";REPORTLINE=" + isReportLine + ";}"));
        return buf_send.toString().getBytes();
    }

    private byte[] getSendPacket(String num_send, String num_recv, String msg, String key, String tranType) throws Exception {
        StringBuffer buf_send = new StringBuffer();
        if (tranType.equals("SEND")) {
            buf_send.append("BEGIN SEND\r\n");
        } else if (tranType.equals("URL")) {
            buf_send.append("BEGIN URL\r\n");
        } else {
            throw new Exception("UnsupportedTranType");
        }
        buf_send.append("RECEIVERNUM:" + num_recv + "\r\n");
        buf_send.append("CALLBACK:" + num_send + "\r\n");
        String[] arrNewLines = msg.split("\n");
        int i = 0;
        while (i < arrNewLines.length) {
            String[] arrCarriageReturn = arrNewLines[i].split("\r");
            int j = 0;
            while (j < arrCarriageReturn.length) {
                buf_send.append("DATA:").append(arrCarriageReturn[j]).append("\r\n");
                ++j;
            }
            ++i;
        }
        if (!this.sessImpl.isReceiverCreated()) {
            key = String.valueOf(key) + "N";
        }
        buf_send.append("KEY:" + key + "\r\n");
        buf_send.append("END\r\n");
        if (tranType.equals("SEND")) {
            this.logger.info((Object)("SEND{SNUM=" + num_send + ";RNUM=" + num_recv + ";KEY=" + key + ";}"));
        } else if (tranType.equals("URL")) {
            this.logger.info((Object)("URL{SNUM=" + num_send + ";RNUM=" + num_recv + ";KEY=" + key + ";}"));
        }
        return buf_send.toString().getBytes("KSC5601");
    }

    private byte[] getPingPongPacket(String key, String tranType) throws Exception {
        StringBuffer buf_send = new StringBuffer();
        if (tranType.equals("PING")) {
            buf_send.append("BEGIN PING\r\n");
        } else if (tranType.equals("PONG")) {
            buf_send.append("BEGIN PONG\r\n");
        } else {
            throw new Exception();
        }
        buf_send.append("KEY:" + key + "\r\n");
        buf_send.append("END\r\n");
        if (tranType.equals("PING")) {
            this.logger.info((Object)("SENDER_PING{KEY=" + key + ";}"));
        } else if (tranType.equals("PONG")) {
            this.logger.info((Object)("SENDER_PONG{KEY=" + key + ";}"));
        }
        return buf_send.toString().getBytes();
    }

    private void sendPacket(byte[] packet) throws IOException {
        this.output.flush();
        this.output.write(packet, 0, packet.length);
        this.output.flush();
    }

    private String[] splitPacket(String packetLine, String sep) {
        String[] ret = new String[]{"", ""};
        StringTokenizer st = new StringTokenizer(packetLine, sep);
        try {
            ret[0] = st.nextToken();
            ret[1] = st.nextToken();
        }
        catch (NoSuchElementException e) {
            ret[1] = "";
        }
        return ret;
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Sender Input Buffer Close :", (Throwable)e);
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Sender Output Stream Close :", (Throwable)e);
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Sender Socket Close :", (Throwable)e);
            }
        }
    }

    private Hashtable recvPacket() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String[] values = new String[2];
        String readLine = "";
        do {
            try {
                readLine = this.input.readLine();
            }
            catch (InterruptedIOException e) {
                return ht;
            }
            catch (IOException e) {
                this.logger.warn((Object)"Sender ReceivePacket :", (Throwable)e);
                return ht;
            }
            if (readLine == null) break;
            if (readLine.startsWith("BEGIN")) {
                values = this.splitPacket(readLine, " ");
                ht.put(values[0], values[1]);
                continue;
            }
            values = this.splitPacket(readLine, ":");
            ht.put(values[0], values[1]);
        } while (!readLine.startsWith("END"));
        return ht;
    }

    private void process(Hashtable ht) {
        if (ht.containsKey("BEGIN") && ((String)ht.get("BEGIN")).equals("ACK")) {
            try {
                this.sendPacket(this.getPingPongPacket("11111", "PONG"));
                this.logger.info((Object)("ACK{KEY=" + (String)ht.get("KEY") + ";CODE=" + (String)ht.get("CODE") + ";}"));
            }
            catch (Exception e) {
                this.logger.warn((Object)"Proces Function Exception :", (Throwable)e);
            }
        }
    }

    public SMEResponse send(SMERequest request) throws SMEException {
        return this.send(request, null);
    }

    public SMEResponse send(SMERequest request, String to) throws SMEException {
        String msg = "";
        String action = "";
        if (this.socket == null || !this.socket.isConnected()) {
            this.openConnection();
        }
        if (request.getCallbackURL() == null || request.getCallbackURL().equals("")) {
            msg = request.getText();
            action = "SEND";
        } else {
            if (request.getCallbackURL().indexOf(" ") > -1) {
                throw new SMEException("CallbackURL has blank char");
            }
            msg = String.valueOf(request.getCallbackURL()) + " " + request.getText();
            action = "URL";
        }
        Hashtable ht = new Hashtable();
        try {
            if (request.getMessageId().length() <= 39) {
                if (request.getTo().length() == 10 || request.getTo().length() == 11) {
                    if (request.getFrom().length() <= 20) {
                        this.sendPacket(this.getSendPacket(request.getFrom(), request.getTo(), msg, request.getMessageId(), action));
                        ht = this.recvPacket();
                        this.logger.info((Object)("ACK{KEY=" + (String)ht.get("KEY") + ";CODE=" + (String)ht.get("CODE") + ";}"));
                    } else {
                        this.logger.error((Object)(" FROM LENGTH ERROR : " + request.getFrom()));
                    }
                } else {
                    this.logger.error((Object)(" TO LENGTH ERROR  : " + request.getTo()));
                }
            } else {
                this.logger.error((Object)("MSGID LENGTH ERROR : " + request.getMessageId().length()));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Send Exception :", (Throwable)e);
        }
        return new SMEResponseImpl(this.hashtableToSMEPacket(ht));
    }

    private SMEPacket hashtableToSMEPacket(Hashtable ht) {
        SMEPacket packet = new SMEPacket();
        if (ht != null) {
            Enumeration keys = ht.keys();
            while (keys.hasMoreElements()) {
                String n = (String)keys.nextElement();
                String v = (String)ht.get(n);
                packet.setProperty(n, v);
            }
        }
        return packet;
    }

    public void setUseEncrypt(boolean useEncrypt) {
        this.useEncrypt = useEncrypt;
    }
}

