/*
 * Decompiled with CFR 0.152.
 */
package x3.client.smeapi.impl;

import x3.client.smeapi.SMEException;
import x3.client.smeapi.SMEReceiver;
import x3.client.smeapi.SMERequest;
import x3.client.smeapi.SMESender;
import x3.client.smeapi.SMESession;
import x3.client.smeapi.impl.SMEConnectionImpl;
import x3.client.smeapi.impl.SMEConstants;
import x3.client.smeapi.impl.SMEReceiverImpl;
import x3.client.smeapi.impl.SMERequestImpl;
import x3.client.smeapi.impl.SMESenderImpl;

public class SMESessionImpl
implements SMESession,
SMEConstants {
    private static Object serialLock = new Object();
    private static int serial = 0;
    private SMEConnectionImpl connImpl;
    private SMESenderImpl sender;
    private SMEReceiverImpl receiver;
    private boolean m_bIsReceiverCreate;
    private String key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SMESessionImpl(SMEConnectionImpl conn) {
        this.connImpl = conn;
        Object object = serialLock;
        synchronized (object) {
            this.key = "Session." + serial;
            ++serial;
        }
        this.m_bIsReceiverCreate = false;
    }

    public String key() {
        return this.key;
    }

    public boolean isReceiverCreated() {
        return this.m_bIsReceiverCreate;
    }

    public void setReceiverCreated(boolean bCreate) {
        this.m_bIsReceiverCreate = bCreate;
    }

    public SMEReceiverImpl getReceiver() {
        return this.receiver;
    }

    public synchronized void close() throws SMEException {
        if (this.sender != null) {
            this.sender = null;
        }
        if (this.receiver != null) {
            this.receiver = null;
        }
    }

    public synchronized SMESender createSender() throws SMEException {
        if (this.sender == null || !this.sender.isConnected()) {
            this.sender = new SMESenderImpl(this.connImpl, this);
        }
        return this.sender;
    }

    public synchronized SMEReceiver createReceiver() throws SMEException {
        if (this.receiver == null || !this.receiver.isConnected()) {
            this.receiver = new SMEReceiverImpl(this.connImpl, this);
        }
        this.setReceiverCreated(true);
        return this.receiver;
    }

    public synchronized SMERequest createRequest() throws SMEException {
        return new SMERequestImpl(this);
    }
}

