/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJobRegistry
implements JobRegistry {
    private final ConcurrentMap<String, JobFactory> map = new ConcurrentHashMap<String, JobFactory>();

    @Override
    public void register(JobFactory jobFactory) throws DuplicateJobException {
        Assert.notNull((Object)jobFactory);
        String name = jobFactory.getJobName();
        Assert.notNull((Object)name, (String)"Job configuration must have a name.");
        JobFactory previousValue = this.map.putIfAbsent(name, jobFactory);
        if (previousValue != null) {
            throw new DuplicateJobException("A job configuration with this name [" + name + "] was already registered");
        }
    }

    @Override
    public void unregister(String name) {
        Assert.notNull((Object)name, (String)"Job configuration must have a name.");
        this.map.remove(name);
    }

    @Override
    public Job getJob(String name) throws NoSuchJobException {
        JobFactory factory = (JobFactory)this.map.get(name);
        if (factory == null) {
            throw new NoSuchJobException("No job configuration with the name [" + name + "] was registered");
        }
        return factory.createJob();
    }

    public Set<String> getJobNames() {
        return Collections.unmodifiableSet(this.map.keySet());
    }
}

