/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.listener.AbstractListenerFactoryBean;
import org.springframework.batch.core.listener.ListenerMetaData;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListenerParser {
    private static final String ID_ATTR = "id";
    private static final String REF_ATTR = "ref";
    private static final String BEAN_ELE = "bean";
    private static final String REF_ELE = "ref";

    public AbstractBeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(this.getBeanClass());
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    public void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("delegate", (Object)AbstractListenerParser.parseListenerElement(element, parserContext, (BeanDefinition)builder.getRawBeanDefinition()));
        ManagedMap metaDataMap = new ManagedMap();
        for (String metaDataPropertyName : this.getMethodNameAttributes()) {
            String listenerMethod = element.getAttribute(metaDataPropertyName);
            if (!StringUtils.hasText((String)listenerMethod)) continue;
            metaDataMap.put((Object)metaDataPropertyName, (Object)listenerMethod);
        }
        builder.addPropertyValue("metaDataMap", (Object)metaDataMap);
    }

    public static BeanMetadataElement parseListenerElement(Element element, ParserContext parserContext, BeanDefinition enclosing) {
        String listenerRef = element.getAttribute("ref");
        List beanElements = DomUtils.getChildElementsByTagName((Element)element, (String)BEAN_ELE);
        List refElements = DomUtils.getChildElementsByTagName((Element)element, (String)"ref");
        AbstractListenerParser.verifyListenerAttributesAndSubelements(listenerRef, beanElements, refElements, element, parserContext);
        if (StringUtils.hasText((String)listenerRef)) {
            return new RuntimeBeanReference(listenerRef);
        }
        if (beanElements.size() == 1) {
            Element beanElement = (Element)beanElements.get(0);
            BeanDefinitionHolder beanDefinitionHolder = parserContext.getDelegate().parseBeanDefinitionElement(beanElement, enclosing);
            parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDefinitionHolder);
            return beanDefinitionHolder;
        }
        return (BeanMetadataElement)parserContext.getDelegate().parsePropertySubElement((Element)refElements.get(0), null);
    }

    private static void verifyListenerAttributesAndSubelements(String listenerRef, List<Element> beanElements, List<Element> refElements, Element element, ParserContext parserContext) {
        int total = (StringUtils.hasText((String)listenerRef) ? 1 : 0) + beanElements.size() + refElements.size();
        if (total != 1) {
            StringBuilder found = new StringBuilder();
            if (total == 0) {
                found.append("None");
            } else {
                if (StringUtils.hasText((String)listenerRef)) {
                    found.append("'ref' attribute, ");
                }
                if (beanElements.size() == 1) {
                    found.append("<bean/> element, ");
                } else if (beanElements.size() > 1) {
                    found.append(beanElements.size() + " <" + BEAN_ELE + "/> elements, ");
                }
                if (refElements.size() == 1) {
                    found.append("<ref/> element, ");
                } else if (refElements.size() > 1) {
                    found.append(refElements.size() + " <" + "ref" + "/> elements, ");
                }
                found.delete(found.length() - 2, found.length());
            }
            String id = element.getAttribute(ID_ATTR);
            parserContext.getReaderContext().error("The <" + element.getTagName() + (StringUtils.hasText((String)id) ? " id=\"" + id + "\"" : "") + "/> element must have exactly one of: '" + "ref" + "' attribute, <" + BEAN_ELE + "/> attribute, or <" + "ref" + "/> element.  Found: " + found + ".", (Object)element);
        }
    }

    private List<String> getMethodNameAttributes() {
        ArrayList<String> methodNameAttributes = new ArrayList<String>();
        for (ListenerMetaData metaData : this.getMetaDataValues()) {
            methodNameAttributes.add(metaData.getPropertyName());
        }
        return methodNameAttributes;
    }

    protected abstract Class<? extends AbstractListenerFactoryBean> getBeanClass();

    protected abstract ListenerMetaData[] getMetaDataValues();
}

