/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.listener.OrderedComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChunkListener
implements ChunkListener {
    private OrderedComposite<ChunkListener> listeners = new OrderedComposite();

    public void setListeners(List<? extends ChunkListener> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(ChunkListener chunkListener) {
        this.listeners.add(chunkListener);
    }

    @Override
    public void afterChunk() {
        Iterator<ChunkListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ChunkListener listener = iterator.next();
            listener.afterChunk();
        }
    }

    @Override
    public void beforeChunk() {
        Iterator<ChunkListener> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ChunkListener listener = iterator.next();
            listener.beforeChunk();
        }
    }
}

