/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.batch.core.repository.dao.JdbcJobInstanceDao;
import org.springframework.batch.core.repository.dao.JdbcStepExecutionDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.AbstractJobRepositoryFactoryBean;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JobRepositoryFactoryBean
extends AbstractJobRepositoryFactoryBean
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog(JobRepositoryFactoryBean.class);
    private DataSource dataSource;
    private SimpleJdbcOperations jdbcTemplate;
    private String databaseType;
    private String tablePrefix = "BATCH_";
    private DataFieldMaxValueIncrementerFactory incrementerFactory;
    private int maxVarCharLength = 2500;
    private LobHandler lobHandler;

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setMaxVarCharLength(int maxVarCharLength) {
        this.maxVarCharLength = maxVarCharLength;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseType(String dbType) {
        this.databaseType = dbType;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setIncrementerFactory(DataFieldMaxValueIncrementerFactory incrementerFactory) {
        this.incrementerFactory = incrementerFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"DataSource must not be null.");
        this.jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        if (this.incrementerFactory == null) {
            this.incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(this.dataSource);
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseType.fromMetaData((DataSource)this.dataSource).name();
            logger.info((Object)("No database type set, using meta data indicating: " + this.databaseType));
        }
        if (this.lobHandler == null && this.databaseType.equalsIgnoreCase(DatabaseType.ORACLE.toString())) {
            this.lobHandler = new OracleLobHandler();
        }
        Assert.isTrue((boolean)this.incrementerFactory.isSupportedIncrementerType(this.databaseType), (String)("'" + this.databaseType + "' is an unsupported database type.  The supported database types are " + StringUtils.arrayToCommaDelimitedString((Object[])this.incrementerFactory.getSupportedIncrementerTypes())));
        super.afterPropertiesSet();
    }

    protected JobInstanceDao createJobInstanceDao() throws Exception {
        JdbcJobInstanceDao dao = new JdbcJobInstanceDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setJobIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }

    protected JobExecutionDao createJobExecutionDao() throws Exception {
        JdbcJobExecutionDao dao = new JdbcJobExecutionDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setJobExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setExitMessageLength(this.maxVarCharLength);
        dao.afterPropertiesSet();
        return dao;
    }

    protected StepExecutionDao createStepExecutionDao() throws Exception {
        JdbcStepExecutionDao dao = new JdbcStepExecutionDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setStepExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "STEP_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        dao.setExitMessageLength(this.maxVarCharLength);
        dao.afterPropertiesSet();
        return dao;
    }

    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        JdbcExecutionContextDao dao = new JdbcExecutionContextDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setTablePrefix(this.tablePrefix);
        dao.setClobTypeToUse(this.determineClobTypeToUse(this.databaseType));
        if (this.lobHandler != null) {
            dao.setLobHandler(this.lobHandler);
        }
        dao.afterPropertiesSet();
        dao.setShortContextLength(this.maxVarCharLength);
        return dao;
    }

    private int determineClobTypeToUse(String databaseType) {
        if (DatabaseType.SYBASE == DatabaseType.valueOf((String)databaseType.toUpperCase())) {
            return -1;
        }
        return 2005;
    }
}

