/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.util;

import java.lang.reflect.Modifier;
import org.aopalliance.aop.Advice;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.DefaultScopedObject;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.batch.core.scope.util.ContextFactory;
import org.springframework.batch.core.scope.util.PlaceholderTargetSource;
import org.springframework.batch.core.scope.util.StepContextFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
BeanFactoryAware {
    private final PlaceholderTargetSource scopedTargetSource = new PlaceholderTargetSource();
    private String targetBeanName;
    private Object proxy;
    private final ContextFactory contextFactory;

    public PlaceholderProxyFactoryBean(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
        this.scopedTargetSource.setTargetBeanName(targetBeanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        this.scopedTargetSource.setBeanFactory(beanFactory);
        this.scopedTargetSource.setContextFactory(this.contextFactory);
        ProxyFactory pf = new ProxyFactory();
        pf.copyFrom((ProxyConfig)this);
        pf.setTargetSource((TargetSource)this.scopedTargetSource);
        Class beanType = beanFactory.getType(this.targetBeanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot create scoped proxy for bean '" + this.targetBeanName + "': Target type could not be determined at the time of proxy creation.");
        }
        if (!this.isProxyTargetClass() || beanType.isInterface() || Modifier.isPrivate(beanType.getModifiers())) {
            pf.setInterfaces(ClassUtils.getAllInterfacesForClass((Class)beanType, (ClassLoader)cbf.getBeanClassLoader()));
        }
        DefaultScopedObject scopedObject = new DefaultScopedObject(cbf, this.scopedTargetSource.getTargetBeanName());
        pf.addAdvice((Advice)new DelegatingIntroductionInterceptor((Object)scopedObject));
        pf.addInterface(AopInfrastructureBean.class);
        this.scopedTargetSource.afterPropertiesSet();
        this.proxy = pf.getProxy(cbf.getBeanClassLoader());
    }

    public Object getObject() {
        if (this.proxy == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.proxy;
    }

    public Class<?> getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.scopedTargetSource != null) {
            return this.scopedTargetSource.getTargetClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public static BeanDefinitionHolder createScopedProxy(BeanDefinitionHolder definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        String originalBeanName = definition.getBeanName();
        BeanDefinition targetDefinition = definition.getBeanDefinition();
        RootBeanDefinition proxyDefinition = new RootBeanDefinition(PlaceholderProxyFactoryBean.class);
        proxyDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)new StepContextFactory());
        proxyDefinition.setOriginatingBeanDefinition(definition.getBeanDefinition());
        proxyDefinition.setSource(definition.getSource());
        proxyDefinition.setRole(2);
        String targetBeanName = "lazyBindingProxy." + originalBeanName;
        proxyDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)targetBeanName);
        if (proxyTargetClass) {
            targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
            proxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.TRUE);
        } else {
            proxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.FALSE);
        }
        proxyDefinition.setAutowireCandidate(targetDefinition.isAutowireCandidate());
        targetDefinition.setAutowireCandidate(false);
        registry.registerBeanDefinition(targetBeanName, targetDefinition);
        return new BeanDefinitionHolder((BeanDefinition)proxyDefinition, originalBeanName, definition.getAliases());
    }
}

