/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.util.StringUtils;

public class SqlWindowingPagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    public String generateFirstPageQuery(int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ( ");
        sql.append("SELECT ").append(this.getSelectClause()).append(", ");
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause()).append(this.getWhereClause() == null ? "" : " WHERE " + this.getWhereClause());
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER <= ").append(pageSize);
        return sql.toString();
    }

    protected Object getSubQueryAlias() {
        return "AS TMP_SUB ";
    }

    protected Object extractTableAlias() {
        String alias = "" + this.getSubQueryAlias();
        if (StringUtils.hasText((String)alias) && alias.toUpperCase().startsWith("AS")) {
            alias = alias.substring(3).trim() + ".";
        }
        return alias;
    }

    public String generateRemainingPagesQuery(int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ( ");
        sql.append("SELECT ").append(this.getSelectClause()).append(", ");
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause());
        sql.append(" WHERE ");
        if (this.getWhereClause() != null) {
            sql.append(this.getWhereClause());
            sql.append(" AND ");
        }
        sql.append(this.getSortKey());
        if (this.isAscending()) {
            sql.append(" > ");
        } else {
            sql.append(" < ");
        }
        sql.append(this.getSortKeyPlaceHolder());
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER <= ").append(pageSize);
        return sql.toString();
    }

    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int lastRowNum = page * pageSize;
        if (lastRowNum <= 0) {
            lastRowNum = 1;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT SORT_KEY FROM ( ");
        sql.append("SELECT ").append(this.getSortKey()).append(" AS SORT_KEY, ");
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause());
        sql.append(this.getWhereClause() == null ? "" : " WHERE " + this.getWhereClause());
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER = ").append(lastRowNum);
        return sql.toString();
    }

    protected String getOverClause() {
        return "ORDER BY " + this.getSortKeyWithoutAlias() + " " + this.getAscendingClause();
    }

    protected String getOverSubstituteClauseStart() {
        return "";
    }

    protected String getOverSubstituteClauseEnd() {
        return "";
    }

    private String getAscendingClause() {
        if (this.isAscending()) {
            return "ASC";
        }
        return "DESC";
    }
}

