/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.namespace;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.xml.handler.ClassValidationElementHandler;
import org.springmodules.validation.bean.conf.loader.xml.handler.PropertyValidationElementHandler;
import org.springmodules.validation.bean.conf.namespace.ValidationBeansParserConstants;
import org.springmodules.validation.util.io.FileIterator;
import org.springmodules.validation.util.xml.DomUtils;
import org.springmodules.validation.util.xml.SubElementsIterator;
import org.w3c.dom.Element;

public class XmlBasedValidatorBeanDefinitionParser
extends AbstractBeanDefinitionParser
implements ValidationBeansParserConstants {
    static final String ELEMENT_NAME = "xml-based-validator";
    private static final String ERROR_CODE_CONVERTER_ATTR = "errorCodeConverter";
    private static final String CLASS_ATTR = "class";
    private static final String PATTERN_ATTR = "pattern";
    private static final String DIR_ATTR = "dir";
    private static final String LOCATION_ATTR = "location";
    private static final String RESOURCE_ELEMENT = "resource";
    private static final String RESOURCE_DIR_ELEMENT = "resource-dir";
    private static final String ELEMENT_HANDLERS_ELEMENT = "element-handlers";
    private static final String HANDLER_ELEMENT = "handler";
    private static final String HANDLER_REGISTRY_PREFIX = "__handler_registry_";
    private static final String CONFIGURATION_LOADER_PREFIX = "__configuration_loader_";
    static /* synthetic */ Class class$org$springmodules$validation$bean$conf$loader$xml$DefaultValidationRuleElementHandlerRegistry;
    static /* synthetic */ Class class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader;
    static /* synthetic */ Class class$org$springmodules$validation$bean$BeanValidator;
    static /* synthetic */ Class class$org$springmodules$validation$bean$conf$loader$xml$handler$PropertyValidationElementHandler;
    static /* synthetic */ Class class$org$springmodules$validation$bean$conf$loader$xml$handler$ClassValidationElementHandler;

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder registryBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springmodules$validation$bean$conf$loader$xml$DefaultValidationRuleElementHandlerRegistry == null ? (class$org$springmodules$validation$bean$conf$loader$xml$DefaultValidationRuleElementHandlerRegistry = XmlBasedValidatorBeanDefinitionParser.class$("org.springmodules.validation.bean.conf.loader.xml.DefaultValidationRuleElementHandlerRegistry")) : class$org$springmodules$validation$bean$conf$loader$xml$DefaultValidationRuleElementHandlerRegistry));
        this.parseHandlerElements(element, registryBuilder);
        AbstractBeanDefinition beanDefinition = registryBuilder.getBeanDefinition();
        String validatorId = this.resolveId(element, beanDefinition, parserContext);
        String registryId = HANDLER_REGISTRY_PREFIX + validatorId;
        parserContext.getRegistry().registerBeanDefinition(registryId, (BeanDefinition)beanDefinition);
        String loaderId = CONFIGURATION_LOADER_PREFIX + validatorId;
        BeanDefinitionBuilder loaderBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader == null ? (class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader = XmlBasedValidatorBeanDefinitionParser.class$("org.springmodules.validation.bean.conf.loader.xml.DefaultXmlBeanValidationConfigurationLoader")) : class$org$springmodules$validation$bean$conf$loader$xml$DefaultXmlBeanValidationConfigurationLoader));
        this.parseResourcesElements(element, loaderBuilder);
        loaderBuilder.addPropertyReference("elementHandlerRegistry", registryId);
        parserContext.getRegistry().registerBeanDefinition(loaderId, (BeanDefinition)loaderBuilder.getBeanDefinition());
        BeanDefinitionBuilder validatorBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springmodules$validation$bean$BeanValidator == null ? (class$org$springmodules$validation$bean$BeanValidator = XmlBasedValidatorBeanDefinitionParser.class$("org.springmodules.validation.bean.BeanValidator")) : class$org$springmodules$validation$bean$BeanValidator));
        if (element.hasAttribute(ERROR_CODE_CONVERTER_ATTR)) {
            validatorBuilder.addPropertyReference(ERROR_CODE_CONVERTER_ATTR, element.getAttribute(ERROR_CODE_CONVERTER_ATTR));
        }
        validatorBuilder.addPropertyReference("configurationLoader", loaderId);
        return validatorBuilder.getBeanDefinition();
    }

    protected Class getBeanClass(Element element) {
        return class$org$springmodules$validation$bean$BeanValidator == null ? (class$org$springmodules$validation$bean$BeanValidator = XmlBasedValidatorBeanDefinitionParser.class$("org.springmodules.validation.bean.BeanValidator")) : class$org$springmodules$validation$bean$BeanValidator;
    }

    protected void parseResourcesElements(Element element, BeanDefinitionBuilder loaderBuilder) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        SubElementsIterator subElements = new SubElementsIterator(element);
        while (subElements.hasNext()) {
            Element subElement = (Element)subElements.next();
            if (subElement.getLocalName().equals(RESOURCE_ELEMENT)) {
                resources.add(this.createResource(subElement));
                continue;
            }
            if (!subElement.getLocalName().equals(RESOURCE_DIR_ELEMENT)) continue;
            resources.addAll(this.createResources(subElement));
        }
        loaderBuilder.addPropertyValue("resources", (Object)resources.toArray(new Resource[resources.size()]));
    }

    protected Resource createResource(Element resourceDefinition) {
        String path = resourceDefinition.getAttribute(LOCATION_ATTR);
        if (!StringUtils.hasText((String)path)) {
            throw new ValidationConfigurationException("Resoruce path is required and cannot be empty");
        }
        return new DefaultResourceLoader().getResource(path);
    }

    protected List createResources(Element resourcesDefinition) {
        String dirName = resourcesDefinition.getAttribute(DIR_ATTR);
        final String pattern = resourcesDefinition.getAttribute(PATTERN_ATTR);
        final AntPathMatcher matcher = new AntPathMatcher();
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                return matcher.match(pattern, file.getName());
            }
        };
        ArrayList<FileSystemResource> resources = new ArrayList<FileSystemResource>();
        FileIterator files = new FileIterator(dirName, filter);
        while (files.hasNext()) {
            File file = (File)files.next();
            resources.add(new FileSystemResource(file));
        }
        return resources;
    }

    protected void parseHandlerElements(Element element, BeanDefinitionBuilder registryBuilder) {
        Element functionsElement = DomUtils.getSingleSubElement(element, "http://www.springmodules.org/validation/bean/validator", ELEMENT_HANDLERS_ELEMENT);
        if (functionsElement == null) {
            return;
        }
        SubElementsIterator handlerElements = new SubElementsIterator(functionsElement, "http://www.springmodules.org/validation/bean/validator", HANDLER_ELEMENT);
        ArrayList<Object> propertyHandlers = new ArrayList<Object>();
        ArrayList<Object> classHandlers = new ArrayList<Object>();
        while (handlerElements.hasNext()) {
            Element handlerElement;
            String className;
            Object handler;
            if ((class$org$springmodules$validation$bean$conf$loader$xml$handler$PropertyValidationElementHandler == null ? XmlBasedValidatorBeanDefinitionParser.class$("org.springmodules.validation.bean.conf.loader.xml.handler.PropertyValidationElementHandler") : class$org$springmodules$validation$bean$conf$loader$xml$handler$PropertyValidationElementHandler).isInstance(handler = this.loadAndInstantiate(className = (handlerElement = (Element)handlerElements.next()).getAttribute(CLASS_ATTR)))) {
                propertyHandlers.add(handler);
                continue;
            }
            if ((class$org$springmodules$validation$bean$conf$loader$xml$handler$ClassValidationElementHandler == null ? XmlBasedValidatorBeanDefinitionParser.class$("org.springmodules.validation.bean.conf.loader.xml.handler.ClassValidationElementHandler") : class$org$springmodules$validation$bean$conf$loader$xml$handler$ClassValidationElementHandler).isInstance(handler)) {
                classHandlers.add(handler);
                continue;
            }
            throw new ValidationConfigurationException("class '" + className + "' is not a property hanlder nor a class handler");
        }
        registryBuilder.addPropertyValue("extraPropertyHandlers", (Object)propertyHandlers.toArray(new PropertyValidationElementHandler[propertyHandlers.size()]));
        registryBuilder.addPropertyValue("extraClassHandlers", (Object)classHandlers.toArray(new ClassValidationElementHandler[classHandlers.size()]));
    }

    protected Object loadAndInstantiate(String className) {
        try {
            Class clazz = ClassUtils.forName((String)className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ValidationConfigurationException("Could not load class '" + className + "'", cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new ValidationConfigurationException("Could not instantiate class '" + className + "'", iae);
        }
        catch (InstantiationException ie) {
            throw new ValidationConfigurationException("Could not instantiate class '" + className + "'", ie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

